% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addWellCalib.R
\name{addWellCalib}
\alias{addWellCalib}
\title{Visualizes a measure for well calibration on the RBP curve.}
\usage{
addWellCalib(
  obj,
  plot.values = TRUE,
  subplot.control = list(diff = TRUE),
  col = shape::greycol(10L, interval = c(0.3, 1)),
  pos = NULL
)
}
\arguments{
\item{obj}{[\code{\link{RBPObj}}]\cr
Data container for RBP curve.}

\item{plot.values}{[\code{logical(1)}]\cr
Whether the values of the corresponding measure should be added to the plot?
Default is \code{FALSE}.}

\item{subplot.control}{[\code{list}]
A named list of arguments that will be passed to \code{\link{barplot}}.
Additionally, you can set \code{diff = TRUE} to plot differences of the 
equally collored areas or \code{diff = FALSE} to directly plot the areas 
of the equally collored areas in juxtaposed bars.}

\item{col}{[\code{character} | \code{numeric}]\cr
A specification for the the plotting color for the areas.}

\item{pos}{[\code{list}] 
A named List that determines the \code{x} and \code{y} positioning of a subplot that
compares the areas in additional barplots (see \code{\link[TeachingDemos]{subplot}}).
Can be \code{NA} for no additional subplot.
Default is \code{pos = NULL} for an auto positioning in the topleft quadrant.}
}
\value{
A matrix that contains the average of the \dQuote{probabilities within deciles}
  conditional on Y.
}
\description{
A measure for a well calibrated model can be obtained by
grouping the predicted probabilities via deciles yielding 10 groups.
The equally collored areas belong to a specific group. When each of the two  
equally collored areas are similar, the model is well calibrated.
}
