% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RAT.R
\name{h.index}
\alias{h.index}
\title{H-index.}
\usage{
h.index(biblio, fulldata = FALSE)
}
\arguments{
\item{biblio}{A data.frame exported from Web of Science as tab delimited text, full record.}

\item{fulldata}{if TRUE returns publication and citation counts.}
}
\value{
The h-index value. If fulldata = TRUE a list with full data.
}
\description{
Calculates the h-index.
}
\details{
The h-index is a measure of scientific output calculated as the h number of papers with more than h citations (Hirsch, 2005).
}
\examples{
data(biblio)
h.index(biblio)
h.index(biblio, TRUE)
}
\references{
Hirsch, J.E. (2005). An index to quantify an individual's scientific research output. PNAS, 102: 16569–16572. doi:10.1073/pnas.0507655102.
}
