% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_flgi_binary.r
\name{sim_flgi_binary}
\alias{sim_flgi_binary}
\title{Simulate a Trial Using Forward-Looking Gittins Index for Binary Endpoint}
\usage{
sim_flgi_binary(
  Gittinstype,
  df,
  gittins = NULL,
  Pats,
  nMax,
  TimeToOutcome,
  enrollrate,
  I0,
  K,
  noRuns2 = 100,
  Tsize,
  ptrue,
  block,
  rule,
  ztype,
  stopbound,
  side
)
}
\arguments{
\item{Gittinstype}{type of Gittins indices, should be set to 'binary' in this function.}

\item{df}{discount factor which is the multiplier for loss at each additional patient in the future.
Available values are 0, 0.5, 0.7, 0.99 and 0.995. The maximal sample size can be up to 2000.}

\item{gittins}{user specified Gittins indices for calculation in this function. Recommend using the
\code{bmab_gi_multiple_ab} function from \code{gittins} package. If \code{gittins} is provided,
\code{Gittinstype} and \code{df} should be NULL.}

\item{Pats}{the number of patients accrued within a certain time frame indicates the
count of individuals who have been affected by the disease during that specific period,
for example, a month or a day. If this number is 10, it represents that
10 people have got the disease within the specified time frame.}

\item{nMax}{the assumed maximum accrued number of patients with the disease in the population, this number
should be chosen carefully to ensure a sufficient number of patients are simulated,
especially when considering the delay mechanism.}

\item{TimeToOutcome}{the distribution of delayed response times or a fixed delay time for responses.
The delayed time could be a month, a week or any other time frame. When the unit changes,
the number of TimeToOutcome should also change. It can be in the format
of expression(rnorm( length( vStartTime ),30, 3)), representing delayed responses
with a normal distribution, where the mean is 30 days and the standard deviation is 3 days.}

\item{enrollrate}{probability that patients in the population can enroll in the trial.
This parameter is related to the number of people who have been affected by the disease in the population,
following an exponential distribution.}

\item{I0}{a matrix with K rows and 2 columns, where the numbers inside are equal to the prior parameters, and
K is equal to the total number of arms. For example, matrix(1,nrow=2,ncol=2) means that the prior
distributions for two-armed trials are beta(1,1); matrix(c(2,3),nrow=2,ncol=2,byrow = TRUE) means that the prior
distributions for two-armed trials are beta(2,3). The first column represents the prior of the number of successes,
and the second column represents the prior of the number of failures.}

\item{K}{number of total arms in the trial.}

\item{noRuns2}{number of simulations for simulated allocation probabilities within each block. Default value is
set to 100, which is recommended in \insertCite{Villar2015}{RARtrials}.}

\item{Tsize}{maximal sample size for the trial.}

\item{ptrue}{a vector of hypotheses, for example, as c(0.1,0.1) where 0.1 stands for the success probability
for both groups. Another example is c(0.1,0.3) where 0.1 and 0.3 stand for the success probability for the control and
the treatment group, respectively.}

\item{block}{block size.}

\item{rule}{rules can be used in this function, with values 'FLGI PM', 'FLGI PD' or 'CFLGI'.
'FLGI PM' stands for making decision based on posterior mean;
'FLGI PD' stands for making decision based on posterior distribution;
'CFLGI' stands for controlled forward-looking Gittins Index.}

\item{ztype}{Z test statistics, with choice of values from 'pooled' and 'unpooled'.}

\item{stopbound}{the cut-off value for Z test statistics, which is simulated under the null hypothesis.}

\item{side}{direction of a one-sided test, with values 'upper' or 'lower'.}
}
\value{
\code{sim_flgi_binary} returns an object of class "flgi". An object of class "flgi" is a list containing 
final decision based on the Z test statistics with 1 stands for selected and 0 stands for not selected, final decision based on 
the maximal Gittins Index value at the final stage, Z test statistics, the simulated data set and participants accrued for each arm 
at the time of termination of that group in one trial. The simulated data set includes 5 columns: participant ID number, enrollment time, 
observed time of results, allocated arm, and participants' result.
}
\description{
Function for simulating a trial using the forward-looking Gittins Index rule and the controlled forward-looking
Gittins Index rule for binary outcomes in trials with 2-5 arms. The conjugate prior distributions
follow Beta (\eqn{Beta(\alpha,\beta)}) distributions and should be the same for each arm.
}
\details{
This function simulates a trial using the forward-looking Gittins Index rule or the
controlled forward-looking Gittins Index rule under both no delay and delayed scenarios.
The cut-off value used for \code{stopbound} is obtained by simulations using \code{flgi_stop_bound_binary}.
Considering the delay mechanism, \code{Pats} (the number of patients accrued within a certain time frame),
\code{nMax} (the assumed maximum accrued number of patients with the disease in the population) and 
\code{TimeToOutcome} (the distribution of delayed response times or a fixed delay time for responses) 
are parameters in the functions adapted from \url{https://github.com/kwathen/IntroBayesianSimulation}.
Refer to the website for more details.
}
\examples{
#The forward-looking Gittins Index rule with delayed responses follow a normal distribution
#with a mean of 60 days and a standard deviation of 3 days
\donttest{
sim_flgi_binary(Gittinstype='Binary',df=0.5,Pats=10,nMax=50000,TimeToOutcome=expression(
rnorm( length( vStartTime ),60, 3)),enrollrate=0.9,I0= matrix(1,nrow=2,2),
K=2,Tsize=992,ptrue=c(0.6,0.7),block=20,rule='FLGI PM',ztype='unpooled',
stopbound=1.9991,side='upper')}
}
\references{
\insertRef{Villar2015}{RARtrials}
}
