% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfit.R0.R.R
\name{plotfit.R0.R}
\alias{plotfit.R0.R}
\title{Plot a model fit for \code{R0.R} objects}
\usage{
\method{plotfit}{R0.R}(x, xscale = "w", SB.dist = TRUE, ...)
}
\arguments{
\item{x}{An output of \code{est.R0.xx()} (class \code{R0.R}).}

\item{xscale}{Scale to be adjusted on x-axis. Can be \code{d} (day), \code{w} (week (default)), \code{f} (fornight), \code{m} (month).}

\item{SB.dist}{Boolean. Should the R distirbution throughout the epidemic be plotted for the SB method (defaults to \code{TRUE}) ?}

\item{...}{Parameters passed to inner functions.}
}
\value{
This function does not return any data.
Called for side effect. Draws the fit of one estimation method to the data.
}
\description{
Plot the fit of a single model output to epidemic data.
}
\details{
For internal use. This function is called by the \code{\link[=plotfit]{plotfit()}} S3 method.
Depending on the estimation method, either \code{\link[=plotfitRxx]{plotfitRxx()}}, \code{\link[=plotfitRAR]{plotfitRAR()}} or
\code{\link[=plotfitRSB]{plotfitRSB()}} will be called.
}
\author{
Pierre-Yves Boelle, Thomas Obadia
}
\keyword{internal}
