% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrity.checks.R
\name{integrity.checks}
\alias{integrity.checks}
\title{Integrity checks for input parameters}
\usage{
integrity.checks(
  epid,
  GT,
  t,
  begin,
  end,
  date.first.obs,
  time.step,
  AR,
  S0,
  methods
)
}
\arguments{
\item{epid}{Epidemic dataset, expecting incidence counts in a varity of possible formats (see \code{\link[=check.incid]{check.incid()}}).}

\item{GT}{Generation time distribution from \code{\link[=generation.time]{generation.time()}}.}

\item{t}{Vector of dates at which incidence was observed.}

\item{begin}{Begin date for estimation. Can be an integer or a date (YYYY-mm-dd or YYYY/mm/dd).}

\item{end}{End date for estimation. Can be an integer or a date (YYYY-mm-dd or YYYY/mm/dd).}

\item{date.first.obs}{Optional date of first observation, if \code{t} not specified.}

\item{time.step}{Optional. If date of first observation is specified, number of day between each incidence observation.}

\item{AR}{Attack rate as a percentage from total population.}

\item{S0}{Initial proportion of the population considered susceptible.}

\item{methods}{Vector of methods to be used for R/R0/Rt estimation. Must be provided as \code{c("method 1", "method 2", ...)}.}
}
\value{
A list with two components, \code{begin} and  \code{end}.
}
\description{
Before any requested estimation routine is ran, \code{\link[=integrity.checks]{integrity.checks()}} is called
to ensure the data passed as arguments meet the proper format and can be
properly interpreted by subsequent functions.
}
\details{
For internal use. Called by all implemented estimation methods.
All integrity/class checks are handled by this core function. GT must be an
object of class \code{R0.GT}, and epidemic curve along with time values are handled
here. If you plan on calling manually any other estimation function, make sure
data are provided with correct format.

The epidemic curve \code{epid} may be provided as a vector. In that case, a vector
\code{t} may be provided with the dates of observation. If \code{t} is not numeric, an
attempt is made to convert to dates with \code{\link[=as.Date]{as.Date()}}. If \code{t} is not provided,
dates are obtained from the names of incid, and if not available, index
values are used. Finally, one can provide an epidemic curve object generated by
the epitools package (see \code{\link[=check.incid]{check.incid()}} for more details).

A quick note on \code{t}, \code{begin} and \code{end} : when a date vector is provided (\code{t}),
it will be used instead of index values to establish a date-related incidence.
If no date vector is provided, then \code{begin} and \code{end} can still be forced to
\emph{numeric} values. It then links to the corresponding index values for incidence
data. If a date vector is provided, \code{begin} and \code{end} can either be \emph{numeric}
values or \emph{dates}. If numeric, they will link to the correspondig index values
for incidence, and be afterward interpreted as the associated date. If date,
they will be directly associated to incidence data.

Basicly, if specified, \code{begin} and \code{end} must always have the same class.
}
\author{
Pierre-Yves Boelle, Thomas Obadia
}
