% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary.R
\name{dictionary}
\alias{dictionary}
\title{dictionary}
\usage{
dictionary(dtm, remove_stopwords = FALSE)
}
\arguments{
\item{dtm}{A \code{DocumentTermMatrix} object.}

\item{remove_stopwords}{Whether stopwords should be removed from the dictionary.}
}
\value{
A \code{data.frame} with row names indicating the terms, and columns giving the stem,
the number of occurrences, and whether the term is a stopword.
}
\description{
Create a dictionary with information on all words in a corpus.
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
corpus <- import_corpus(file, "factiva", language="en")
dtm <- build_dtm(corpus)
dictionary(dtm)

}
