% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{corpus_clustering}
\alias{corpus_clustering}
\title{corpus_clustering}
\usage{
corpus_clustering(ca, n = 0)
}
\arguments{
\item{ca}{A \code{\link[FactoMineR:CA]{CA}} object resulting from a call to \code{\link{corpus_ca}}.}

\item{n}{Number of clusters to create. If 0 (the default), it is determined by clicking
on the plot to choose the cut height.}
}
\value{
A \code{\link[FactoMineR:HCPC]{HCPC}} object.
}
\description{
Run a hierarchical clustering on documents of a corpus based on
a correspondence analysis. The number of axes from \code{ca} which are
used depends on the value of the \code{n} argument passed to \code{\link{corpus_ca}}.
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
corpus <- import_corpus(file, "factiva", language="en")
dtm <- build_dtm(corpus)
res <- corpus_ca(corpus, dtm, ncp=2, sparsity=0.98)
corpus_clustering(res, 3)

}
