# QuICSeedR

[![R-CMD-check](https://github.com/mancili/QuICSeedR/actions/workflows/R-CMD-check.yml/badge.svg)](https://github.com/mancili/QuICSeedR/actions/workflows/R-CMD-check.yml)

## Overview

QuICSeedR is a comprehensive R package for analyzing and visualizing data from fluorophore-assisted seed amplification assays, such as Real-Time Quaking-Induced Conversion (RT-QuIC) and fluorophore-assisted Protein Misfolding Cyclic Amplification (PMCA). This toolkit addresses limitations in existing software by automating data processing, supporting large-scale analysis, and enabling comparative studies of analysis methods.

## Features

- Automated data processing for RT-QuIC and PMCA assays
- Support for large-scale data analysis
- Comparative analysis of different methodologies
- Visualization tools for assay results
- Statistical analysis functions tailored for seed amplification data

## Installation

You can install the development version of QuICSeedR from GitHub with:

```R
# install.packages("devtools")
devtools::install_github("mancili/QuICSeedR")
```

## Usage

For more detailed examples and function documentation, please refer to the function help pages. The manuscript link will be added here once it becomes available.

## Requirements

- R (>= 4.1.0)

## License

This R package for analyzing seed amplification assay data is available under a dual licensing model: it is freely available under the GNU General Public License v3.0 (GPL-3) for open-source use, and a separate commercial [LICENSE](https://github.com/mancili/QuICSeedR/blob/main/LICENSE) is offered for use cases that require additional rights or support beyond the scope of GPL-3. 

## Author

Manci Li, PhD

ORCID: [0000-0003-3930-7117](https://orcid.org/0000-0003-3930-7117)

## Citation

If you use QuICSeedR in your research, please cite it as follows:

```
Li, M. (2024). QuICSeedR: Data analysis for fluorophore-assisted seed amplification assays. R package version 0.1.2. https://github.com/mancili/QuICSeedR
```

## Contact

For questions and feedback, please contact Dr. Manci Li at li000021@umn.edu.
