% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QPD.R
\name{QPD}
\alias{QPD}
\title{Quantum Prisoner's Dilemma game}
\usage{
QPD(U_Alice, U_Bob, w, x, y, z)
}
\arguments{
\item{U_Alice}{a matrix lying in SU(2)}

\item{U_Bob}{a matrix lying in SU(2)}

\item{w}{a number}

\item{x}{a number}

\item{y}{a number}

\item{z}{a number}
}
\value{
A vector consisting of the expected payoffs to Alice and Bob as its elements according to the strategies played by Alice and Bob and also the payoff values.
}
\description{
This function returns the expected payoffs to Alice and Bob, with the strategy moves by Alice and Bob as two of the inputs. \code{w, x, y, z} are the payoffs to the players corresponding to the choices available to them with the chain of inequalities, \code{z>w>x>y}.
This function also plots the probability distribution plots of the qubits for one of all the combinations of the strategies of the players.
}
\examples{
init()
QPD(Hadamard(Q$I2), sigmaZ(Q$I2), 3, 1, 0, 5)

}
\references{
\url{https://arxiv.org/pdf/quant-ph/0506219.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/0208069.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/0004076.pdf}\cr
}
