% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PayoffMatrix_QHawkDove.R
\name{PayoffMatrix_QHawkDove}
\alias{PayoffMatrix_QHawkDove}
\title{Quantum Hawk and Dove game: Payoff Matrix}
\usage{
PayoffMatrix_QHawkDove(moves, v, j, D)
}
\arguments{
\item{moves}{a list of matrices}

\item{v}{a number}

\item{j}{a number}

\item{D}{a number}
}
\value{
The payoff matrices for the two players as two elements of a list.
}
\description{
This function generates the payoff matrix for the Quantum Hawk and Dove game for all the four combinations of \code{p} and \code{q}. \code{moves} is a list of two possible strategies for each of the players and \code{v, j, D} are the value of resource, cost of injury and cost of displaying respectively.
}
\examples{
init()
moves <- list(Q$I2, sigmaX(Q$I2))
PayoffMatrix_QHawkDove(moves, 50, -100, -10)

}
\references{
\url{https://arxiv.org/pdf/quant-ph/0506219.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/0208069.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/0108075.pdf}\cr
}
