% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Rainbow.R
\name{RainbowBS}
\alias{RainbowBS}
\title{Rainbow option valuation via Black-Scholes (BS) model}
\usage{
RainbowBS(o = OptPx(Opt(Style = "Rainbow")), S1 = 100, S2 = 95, D1 = 0,
  D2 = 0, sigma1 = 0.15, sigma2 = 0.2, rho = 0.75, Type = c("Max",
  "Min"))
}
\arguments{
\item{o}{An object of class \code{OptPx}}

\item{S1}{A spot price of the underlying security 1 (usually S1)}

\item{S2}{A spot price of the underlying security 2 (usually S2)}

\item{D1}{A percent yield per annum from the underlying security 1}

\item{D2}{A percent yield per annum from the underlying security 2}

\item{sigma1}{a vector of implied volatilities for the associated security 1}

\item{sigma2}{a vector of implied volatilities for the associated security 2}

\item{rho}{is the correlation between asset 1 and asset 2}

\item{Type}{Rainbow option type: 'Max' or 'Min'.}
}
\value{
A list of class \code{RainbowBS} consisting of the original \code{OptPx} object
and the option pricing parameters \code{S1}, \code{Type}, \code{isMax}, and \code{isMin}
as well as the computed price \code{PxBS}.
}
\description{
Rainbow Option via Black-Scholes (BS) model
}
\details{
Two types of Rainbow options are priced: \code{'Max'} and \code{'Min'}.
}
\examples{
(o = RainbowBS())$PxBS

  o = OptPx(Opt(Style = 'Rainbow',  Right = "Put"), r = 0.08)
  RainbowBS(o, S1=100, S2=95, D1=0,D2=0,sigma1=0.15,sigma2=0.2, rho=0.75,Type='Min')

  o = OptPx(Opt(Style = 'Rainbow', K = 102, ttm = 1, Right = "Put"), r = 0.08)
  RainbowBS(o, S1=100, S2=95, D1=0,D2=0,sigma1=0.15,sigma2=0.2, rho=0.75,Type='Min')

  o=OptPx(Opt(Style = 'Rainbow', K = 102, ttm = 1, Right = "Put"), r = 0.08)
  RainbowBS(o, S1=100, S2=95, D1=0,D2=0,sigma1=0.15,sigma2=0.2, rho=0.75,Type='Max')

  o=OptPx(Opt(Style = 'Rainbow', K = 102, ttm = 1, Right = "Call"), r = 0.08)
  RainbowBS(o, S1=100, S2=95, D1=0,D2=0,sigma1=0.15,sigma2=0.2, rho=0.75,Type='Min')

  o=OptPx(Opt(Style = 'Rainbow', K = 102, ttm = 1, Right = "Call"), r = 0.08)
  RainbowBS(o, S1=100, S2=95, D1=0,D2=0,sigma1=0.15,sigma2=0.2, rho=0.75,Type='Max')
}
\author{
Chengwei Ge,Department of Statistics, Rice University, Spring 2015
}
\references{
Zhang Peter G., \emph{Exotic Options}, 2nd ed, 1998.
}

