% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/HolderExtendible.R
\name{HolderExtendibleBS}
\alias{HolderExtendibleBS}
\title{Holder Extendible option valuation via Black-Scholes (BS) model}
\usage{
HolderExtendibleBS(o = OptPx(Opt(Style = "HolderExtendible")), k = 105,
  t1 = 0.5, t2 = 0.75, A = 1)
}
\arguments{
\item{o}{An object of class \code{OptPx}}

\item{k}{The exercise price of the option at t2, a numeric value.}

\item{t1}{The time to maturity of the call option, measured in years.}

\item{t2}{The time to maturity of the put option, measured in years.}

\item{A}{The corresponding asset price has exceeded the exercise price X.}
}
\value{
The original \code{OptPx} object
 and the option pricing parameters \code{t1}, \code{t2},\code{k},\code{A}, and computed price \code{PxBS}.
}
\description{
Computes the price of exotic option (via BS model)
 which gives the holder the right to extend the option's maturity at an additional premium.
}
\examples{
(o = HolderExtendibleBS())$PxBS

o = Opt(Style='HolderExtendible',Right='Call', S0=100, ttm=0.5, K=100)
o = OptPx(o,r=0.08,q=0,vol=0.25)
(o = HolderExtendibleBS(o,k=105,t1=0.5,t2=0.75,A=1))$PxBS

o = Opt("HolderExtendible","Put", S0=100, ttm=0.5, K=100)
o = OptPx(o,r=0.08,q=0,vol=0.25)
(o = HolderExtendibleBS(o,k=90,t1=0.5,t2=0.75,A=1))$PxBS
}
\author{
Le You, Department of Statistics, Rice University, Spring 2015
}
\references{
Hull, J.C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall. ISBN 978-0-13-345631-8,
             \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}
             \cr Haug, Espen G.,\emph{Option Pricing Formulas}, 2ed.
}

