% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Gap.R
\name{GapMC}
\alias{GapMC}
\title{Gap option valuation via Monte Carlo (MC) simulation}
\usage{
GapMC(o = OptPx(Opt(Style = "Gap", Right = "Put", S0 = 5e+05, K = 4e+05, ttm =
  1, ContrSize = 1, SName =
  "Insurance coverage example #26.1, p.601, OFOD, J.C.Hull, 9ed."), r = 0.05, q
  = 0, vol = 0.2), K2 = 350000, NPaths = 5)
}
\arguments{
\item{o}{The \code{OptPx} object (See \code{OptPx()} constructor for more information)}

\item{K2}{The trigger strike price.}

\item{NPaths}{The number of paths (trials) to simulate.}
}
\value{
An \code{OptPx} object. The price is stored under \code{o$PxMC}.
}
\description{
GapMC prices a gap option using the MC method.
  The call payoff is \eqn{S_T-K} when \eqn{S_T>K2}, where \eqn{K_2} is the trigger strike.
  The payoff is increased by \eqn{K_2-K}, which can be positive or negative.
  The put payoff is \eqn{K-S_T} when \eqn{S_T<K_2}.
  Default values are from policyholder-insurance example 26.1, p.601, from referenced OFOD, 9ed, text.
}
\examples{
(o = GapMC())$PxMC  #example 26.1, p.601

o = Opt(Style='Gap', Right='Call', S0=50, K=40, ttm=1)
o = OptPx(o, vol=.2, r=.05, q = .02)
(o = GapMC(o, K2 = 45, NPaths = 5))$PxMC

o = Opt(Style='Gap', Right='Call', S0 = 50, K = 60, ttm = 1)
o = OptPx(o, vol=.25,r=.15, q = .02)
(o = GapMC(o, K2 = 55, NPaths = 5))$PxMC

o = Opt(Style='Gap', Right = 'Put', S0 = 50, K = 57, ttm = .5)
o = OptPx(o, vol = .2, r = .09, q = .2)
(o = GapMC(o, K2 = 50, NPaths = 5))$PxMC

o = Opt(Style='Gap', Right='Call', S0=500000, K=400000, ttm=1)
o = OptPx(o, vol=.2,r=.05, q = 0)
(o = GapMC(o, K2 = 350000, NPaths = 5))$PxMC
}
\author{
Kiryl Novikau, Department of Statistics, Rice University, Spring 2015
}
\references{
Hull, John C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8. \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}.
p.601
}

