% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/DeferredPayment.R
\name{DeferredPaymentLT}
\alias{DeferredPaymentLT}
\title{DeferredPaymentLT}
\usage{
DeferredPaymentLT(o = OptPx(Opt(Style = "DeferredPayment")))
}
\arguments{
\item{o}{An object of class \code{OptPx}}
}
\value{
An object of class \code{OptPx} with price included
}
\description{
A binomial tree pricer of a Deferred Payment option.
An American option that has payment at expiry no matter when exercise,
causing differences in present value (PV) of a payoff.
}
\examples{
(o = DeferredPaymentLT())$PxLT

o = Opt(Style='DeferredPayment', Right="Call", S0=110,ttm=.5,K=110)
(o = DeferredPaymentLT(OptPx(o,r=.05,q=.04,vol=.2,NSteps=5)))$PxLT

o = Opt(Style='DeferredPayment', Right="Put", S0 = 50, ttm=2,K=47)
(o = DeferredPaymentLT(OptPx(o,r=.05,q=.04,vol=.25,NSteps=3)))$PxLT
}
\author{
Max Lee, Department of Statistics, Rice University, Spring 2015
}
\references{
Hull, J.C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8, \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}
}

