% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Asian.R
\name{AsianMC}
\alias{AsianMC}
\title{Asian option valuation with Monte Carlo (MC) simulation.}
\usage{
AsianMC(o = OptPx(o = Opt(Style = "Asian"), NSteps = 5), NPaths = 5)
}
\arguments{
\item{o}{The \code{OptPx} Asian option to price.}

\item{NPaths}{The number of simulation paths to use in calculating the price,}
}
\value{
The option \code{o} with the price in the field \code{PxMC} based on MC simulations.
}
\description{
Calculates the price of an Asian option using Monte Carlo simulations to
determine expected payout.
\cr Assumptions:
\cr The option follows a General Brownian Motion (BM),
\cr \eqn{ds = mu * S * dt + sqrt(vol) * S * dW} where \eqn{dW ~ N(0,1)}.
\cr The value of \eqn{mu} (the expected price increase) is \code{o$r}, the risk free rate of return (RoR).
\cr The averaging period is the life of the option.
}
\examples{
(o = AsianMC())$PxMC #Price = ~5.00,  using default values

  o = OptPx(Opt(Style='Asian'), NSteps = 5)
  (o = AsianMC(o, NPaths=5))$PxMC #Price = ~$5

  (o = AsianMC(NPaths = 5))$PxMC # Price = ~$5

  o = Opt(Style='Asian', Right='Put',S0=10, K=15)
  o = OptPx(o, r=.05, vol=.1, NSteps = 5)
  (o = AsianMC(o, NPaths = 5))$PxMC # Price = ~$4

  #See J.C.Hull, OFOD'2014, 9-ed, ex.26.3, pp.610.
 o = Opt(Style='Asian',S0=50,K=50,ttm=1)
 o = OptPx(o,r=0.1,q=0,vol=0.4,NSteps=5)
 (o = AsianBS(o))$PxBS   #Price is 5.62.
 (o = AsianMC(o))$PxMC
}
\author{
Jake Kornblau, Department of Statistics and Department of Computer Science, Rice University, 2016
}
\references{
Hull, John C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014.
   Prentice Hall. ISBN 978-0-13-345631-8,
    \cr \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}
    \cr \url{http://www.math.umn.edu/~spirn/5076/Lecture16.pdf}
}

