% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terraclimate.R
\name{calc_biovars}
\alias{calc_biovars}
\title{Calculate the Bioclimatic Variables}
\usage{
calc_biovars(data)
}
\arguments{
\item{data}{A data frame containing monthly climate data. The data frame must include:
\itemize{
  \item \strong{year:} The year for each set of monthly data.
  \item \strong{ppt:} Monthly precipitation values (in mm).
  \item \strong{tmin:} Monthly minimum temperature values (in degrees Celsius).
  \item \strong{tmax:} Monthly maximum temperature values (in degrees Celsius).
}
The data should contain 12 rows (one for each month from January to December) per year, 
with the columns sorted in the order of year, ppt, tmin, and tmax.}
}
\value{
A data frame with 19 columns representing the bioclimatic variables (BIO1 to BIO19) and 
an additional column for the year. The output data frame provides one row per year, with 
each column corresponding to one of the bioclimatic variables described above.
}
\description{
This function calculates the 19 standard bioclimatic variables derived from 
monthly temperature and precipitation data. Bioclimatic variables are often 
used in ecological modeling and species distribution modeling to capture biologically 
meaningful patterns in climate data, including annual trends, seasonality, and 
extreme environmental factors. 

The bioclimatic variables represent metrics such as the annual mean temperature, 
temperature seasonality, and precipitation patterns (e.g., wettest or driest quarter).
These metrics help to model species distributions and analyze ecological dynamics.

The bioclimatic variables are coded as follows:
\itemize{
  \item \strong{BIO1} = Annual Mean Temperature
  \item \strong{BIO2} = Mean Diurnal Range (Mean of monthly (max temp - min temp))
  \item \strong{BIO3} = Isothermality (BIO2/BIO7) (* 100)
  \item \strong{BIO4} = Temperature Seasonality (standard deviation * 100)
  \item \strong{BIO5} = Max Temperature of Warmest Month
  \item \strong{BIO6} = Min Temperature of Coldest Month
  \item \strong{BIO7} = Temperature Annual Range (BIO5 - BIO6)
  \item \strong{BIO8} = Mean Temperature of Wettest Quarter
  \item \strong{BIO9} = Mean Temperature of Driest Quarter
  \item \strong{BIO10} = Mean Temperature of Warmest Quarter
  \item \strong{BIO11} = Mean Temperature of Coldest Quarter
  \item \strong{BIO12} = Annual Precipitation
  \item \strong{BIO13} = Precipitation of Wettest Month
  \item \strong{BIO14} = Precipitation of Driest Month
  \item \strong{BIO15} = Precipitation Seasonality (Coefficient of Variation)
  \item \strong{BIO16} = Precipitation of Wettest Quarter
  \item \strong{BIO17} = Precipitation of Driest Quarter
  \item \strong{BIO18} = Precipitation of Warmest Quarter
  \item \strong{BIO19} = Precipitation of Coldest Quarter
}

These variables are computed using temperature and precipitation data in a standard format, 
and are critical for understanding species habitats and the effects of climate on ecosystems.

This work is derived from the \href{https://github.com/rspatial/dismo/blob/master/R/biovars.R}{dismo R package}.
}
\references{
Nix, 1986. A biogeographic analysis of Australian elapid snakes. In: R. Longmore (ed.). 
Atlas of elapid snakes of Australia. Australian Flora and Fauna Series 7. 
Australian Government Publishing Service, Canberra.
}
\author{
Khaled Al-Shamaa (\email{k.el-shamaa@cgiar.org})

Robert Hijmans, Museum of Vertebrate Zoology, UC Berkeley
}
