% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_RG.R
\name{plot_RG}
\alias{plot_RG}
\title{Plot a relationship graph (RG)}
\usage{
plot_RG(
  RG,
  layout.by.group = TRUE,
  vertex.palette = "Set2",
  edge.lty = c(sibling = "dashed", clone = "solid"),
  edge.col = c(sibling = "black", clone = "black"),
  edge.width = 1.5,
  ...
)
}
\arguments{
\item{RG}{\code{igraph} object encoding an RG; see
\code{\link{RG_to_igraph}}.}

\item{layout.by.group}{Logical; if TRUE (default) overrides
the default layout of \code{\link[igraph]{plot.igraph}} so that vertices
that represent parasite genotypes from different episodes are distributed
horizontally and vertices that represent genotypes within episodes are
distributed vertically.}

\item{vertex.palette}{A character string specifying an RColorBrewer palette.
Overrides the default \code{palette} of \code{\link[igraph]{plot.igraph}}.}

\item{edge.lty}{Named vector of edge line types corresponding to different
relationships.}

\item{edge.col}{Named vector of edge colours corresponding to different
relationships.}

\item{edge.width}{Overrides the default \code{edge.width} of
\code{\link[igraph]{plot.igraph}}.}

\item{...}{Additional arguments to pass to \code{\link[igraph]{plot.igraph}}, e.g.,
\code{edge.curved}.}
}
\value{
None
}
\description{
This function is a wrapper around \code{\link[igraph]{plot.igraph}}, written
to group parasite genotypes by episode both spatially and using vertex
colour (specifically, parasite genotypes within episodes are vertically
distributed with some horizontal jitter when \code{layout.by.group = TRUE}
(default), and equicolored), and to ensure clone and sibling edges
are plotted using different line types.
}
\details{
To see how to plot relationship graphs outputted by
\code{\link{compute_posterior}}, please refer to \strong{Exploration of relationship graphs} in
\HTMLVignette{demonstrate-usage}{exploration-of-relationship-graphs}{Demonstrate Pv3Rs usage}.
}
\section{Provenance}{
 This function was adapted from \code{plot_Vivax_model} at
\url{https://github.com/jwatowatson/RecurrentVivax/blob/master/Genetic_Model/iGraph_functions.R}.
}

\examples{
RGs <- enumerate_RGs(c(2, 1, 1), progress.bar = FALSE)
oldpar <- par(no.readonly = TRUE) # record user's options
par(mfrow = c(3, 4), mar = c(0.1, 0.1, 0.1, 0.1))
for (i in 12:23) {
  plot_RG(RGs[[i]],
  edge.col = c(sibling = "gray", clone = "black"),
  edge.lty = c(sibling = "dotted", clone = "solid"),
  edge.curved = 0.1)
  box()
}
par(oldpar) # restore user's options
}
