% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cusum.poly.R
\name{cusum.poly}
\alias{cusum.poly}
\title{Generates CUSUM values for polytomous IRT model based on Van Krimpen-Stoop & Meijer, (2002).}
\usage{
cusum.poly(dat, NCat, ipar = NULL, abi = NULL, IRTmodel = "GRM")
}
\arguments{
\item{dat}{a nxp matrix with n participants and p items. Responses are in 0 as the lowest scores format.}

\item{NCat}{number of categories for each item.}

\item{ipar}{a pxk matrix with given item parameters p items and k item parameters. Item difficulty under the "GRM" or item steps under "PCM" or "GPCM" are in the first columns. The last column is the discrimination parameter.}

\item{abi}{a vector n ability}

\item{IRTmodel}{specify the IRT model ("GRM","PCM","GPCM"). Default is "GRM".}
}
\value{
Returns matrix with with lower and upper cusum statistics for \code{dat}.
}
\description{
Generates CUSUM values for polytomous IRT model based on Van Krimpen-Stoop & Meijer, (2002).
}
\examples{
data(exGRM)
cusum.poly(dat = exGRM, NCat = 6)
}
\references{
Van Krimpen-Stoop, E. M., & Meijer, R. R. (2002). Detection of person misfit in computerized adaptive tests with polytomous items. Applied Psychological Measurement, 26(2), 164-180.
}
