% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{pt2_duration}
\alias{pt2_duration}
\title{Calculate the duration of the module}
\usage{
pt2_duration(x, options = pt2_render_options(), position = 0L, ...)
}
\arguments{
\item{x}{Object for which to determine the duration. Should be of class \code{pt2mod}.}

\item{options}{A list of options used for rendering the audio. Use
\code{\link[=pt2_render_options]{pt2_render_options()}} to obtain default options, or modify them.}

\item{position}{Starting position in the pattern sequence table (\code{pt2_pattern_table()}).
Should be a non negative value smaller than the mule length (\code{pt2_length()}).}

\item{...}{Ignored}
}
\value{
The duration in seconds (as a \code{difftime} class object)
}
\description{
How long a module will play depends on several aspects such as
the length of the pattern sequence table (\code{pt2_pattern_table()}, \code{pt2_length()}),
the speed and tempo at which the patterns are defined,
loops, pattern breaks and delay effects. The duration in seconds of the
module is calculated by this function.
}
\examples{
mod <- pt2_read_mod(pt2_demo())

pt2_duration(mod)
}
\author{
Pepijn de Vries
}
