% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{model_set_FAST}
\alias{model_set_FAST}
\title{Set parameters for FAST model}
\usage{
model_set_FAST(
  maxIter = 30,
  epsLogLik = 1e-05,
  error_heter = TRUE,
  Psi_diag = FALSE,
  verbose = TRUE,
  seed = 1
)
}
\arguments{
\item{maxIter}{the maximum iteration of ICM-EM algorithm. The default is 30.}

\item{epsLogLik}{an optional positive vlaue, tolerance of relative variation rate of the observed pseudo loglikelihood value, defualt as '1e-5'.}

\item{error_heter}{a logical value, whether use the heterogenous error for FAST model, default as \code{TRUE}. If \code{error.heter=FALSE}, then the homogenuous error is used.}

\item{Psi_diag}{a logical value, whether set the conditional covariance matrices of intrisic CAR to diagonal, default as \code{FALSE}}

\item{verbose}{a logical value, whether output the information in iteration.}

\item{seed}{a postive integer, the random seed to be set in initialization.}
}
\value{
return a Seurat object with new reduction  (named reduction.name) added to the `reductions` slot.
}
\description{
Prepare parameters setup for FAST model fitting.
}
\examples{
model_set_FAST(maxIter = 30, epsLogLik = 1e-5,
  error_heter=TRUE, Psi_diag=FALSE, verbose=TRUE, seed=2023)

}
