% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotProActiveResults.R
\name{plotProActiveResults}
\alias{plotProActiveResults}
\title{Plot results of `ProActive()` pattern-matching}
\usage{
plotProActiveResults(pileup, ProActiveResults, elevFilter, saveFilesTo)
}
\arguments{
\item{pileup}{A .txt file containing mapped sequencing read coverages averaged over
100 bp windows/bins.}

\item{ProActiveResults}{The output from `ProActive()`.}

\item{elevFilter}{Optional, only plot results with pattern-matches that achieved an
elevation ratio (max/min) greater than the specified values. Default is no filter.}

\item{saveFilesTo}{Optional, Provide a path to the directory you wish to save
output to. A folder will be made within the provided directory to store
results.}
}
\value{
A list containing ggplot objects
}
\description{
Plot read coverage of contigs/chunks with detected gaps and elevations and their
associated pattern-match.
}
\examples{
ProActivePlots <- plotProActiveResults(sampleMetagenomePileup,
                                       sampleMetagenomeResults)
}
