% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_pretty_div.R
\name{scale_colour_pretty_div}
\alias{scale_colour_pretty_div}
\title{Plotting with PrettyCols palettes for colour ggplot2}
\usage{
scale_colour_pretty_div(palette, direction = 1, legend_title = NULL, ...)
}
\arguments{
\item{palette}{Name of Palette. Run \code{view_all_palettes(type = "div")} to view
options. Must be a diverging palette name.}

\item{direction}{Sets order of colors. Default palette is 1. If direction is -1,
palette color order is reversed}

\item{legend_title}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Deprecated in favour of \code{name}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{scale_colour_gradient2}}}
}
\value{
A ggproto object defining a continuous colour scale for use with ggplot2.
}
\description{
Plotting with PrettyCols palettes for colour ggplot2
}
\examples{
library(ggplot2)
ggplot(data = mtcars, aes(x = mpg, y = disp, colour = wt)) +
  geom_point() +
  scale_colour_pretty_div("PurpleYellows", midpoint = mean(mtcars$wt))
}
