% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_size_curve.R
\name{ProbCurve}
\alias{ProbCurve}
\title{Plot Sample Size Curve}
\usage{
ProbCurve(
  cens_prop = 0,
  med1 = NULL,
  shape1 = NULL,
  rate1 = NULL,
  med2 = NULL,
  shape2 = NULL,
  rate2 = NULL,
  info_reps = 50,
  delta = 1,
  min_n = 10,
  max_n = 100,
  margin = 0,
  target_prob = 0.8,
  use_exp_calc = TRUE
)
}
\arguments{
\item{cens_prop}{Expected censoring proportion.}

\item{med1}{Median for treatment arm 1, assuming shape1 is 1. Overwrites
shape and rate if supplied.}

\item{shape1}{Shape parameter for treatment arm 1.}

\item{rate1}{Rate parameter for treatment arm 1.}

\item{med2}{Median for treatment arm 2, assuming shape2 is 1. Overwrites
shape and rate if supplied.}

\item{shape2}{Shape parameter for treatment arm 2.}

\item{rate2}{Rate parameter for treatment arm 2.}

\item{info_reps}{Replicates used for estimating the observed information
matrix.}

\item{delta}{Increment between consecutive sample sizes to evaluate.}

\item{min_n}{Minimum allowable sample size.}

\item{max_n}{Maximum allowable sample size.}

\item{margin}{Margin of practical equivalence.}

\item{target_prob}{Probability of selecting the more effective treatment.}

\item{use_exp_calc}{If both shape parameters are 1, should the calculations
be performed assuming an exponential distribution for the time to event in
each arm?}
}
\value{
ggplot object.
}
\description{
Plot the probability of selecting the superior treatment as a function of
the sample size n.
}
\examples{
# Plot the selection probability curve for the case of two exponentials
# with medians of 9 and 12 (e.g.) months, and a 2 month margin of
# practical equivalence.
q <- ProbCurve(
  cens_prop = 0.15,
  med1 = 9,
  med2 = 12,
  margin = 2.0
)
}
