% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi.R
\name{chiPr}
\alias{chiPr}
\title{Chi-squared marginal rejection level}
\usage{
chiPr(kappa, M, alpha = 0.05)
}
\arguments{
\item{kappa}{numeric between 0 and infinity}

\item{M}{integer sample size greater than 0}

\item{alpha}{numeric between 0 and 1}
}
\value{
A numeric between 0 and 1.
}
\description{
Computes the marginal rejection level for the
chi-squared pooled p-value.
}
\details{
The marginal rejection level is the maximum p-value
in a single test which results in rejection when all other tests
produce p-values of one. For the chi-squared pooled p-value,
this is an upper tail probability of the chi-squared distribution.
This function computes the upper tail probability for a given
sample size M, degrees of freedom kappa, and rejection level
alpha.
}
\examples{
chiPr(2, 10, 0.05)
chiPr(2, 20, 0.05)
}
\author{
Chris Salahub
}
