% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi.R
\name{chiPc}
\alias{chiPc}
\title{Chi-squared central rejection level}
\usage{
chiPc(kappa, M, alpha = 0.05)
}
\arguments{
\item{kappa}{numeric between 0 and infinity}

\item{M}{integer sample size greater than 0}

\item{alpha}{numeric between 0 and 1}
}
\value{
A numeric between 0 and 1.
}
\description{
Computes the central rejection level for the
chi-squared pooled p-value.
}
\details{
The central rejection level is the maximum p-value
shared among all tests which still results in rejection of the
null using a pooled p-value. For the chi-squared pooled p-value,
this is an upper tail probability of the chi-squared distribution.
This function computes the upper tail probability for a given
sample size M, degrees of freedom kappa, and rejection level
alpha.
}
\examples{
chiPc(2, 10, 0.05)
chiPc(2, 20, 0.05) # increases in sample size
}
\author{
Chris Salahub
}
