% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsPopulationGeneration.R
\name{PoD}
\alias{PoD}
\title{Probability of disease calculation}
\usage{
PoD(titer, pmax, et50, slope, adjustTiters = FALSE, adjustFrom = 0, adjustTo = 0)
}
\arguments{
\item{titer}{numeric vector: subject level titers}

\item{pmax}{numeric: maximum PoD}

\item{et50}{numeric: titer values corresponding to pmax/2 value, PoD(et50) = pmax/2}

\item{slope}{numeric: slope of the PoD curve}

\item{adjustTiters}{boolean: set to TRUE if titer values should be adjusted, for details see \code{PoD} function}

\item{adjustFrom}{numeric: value specifying the detection limit, all values below the detection limit will be adjusted to adjustTo value}

\item{adjustTo}{numeric: value to which titers below the detection limit will be adjusted}
}
\value{
vector of PoDs
}
\description{
Function calculates probability of disease (PoD) corresponding to given titers according to a sigmoid PoD curve.
}
\details{
PoD is calculated as: \deqn{ PoD = p_{max} \frac{ (\frac{et50}{titer})^{\gamma} }{ 1 + (\frac{et50}{titer})^{\gamma}}, \ for \ titers \ > 0}{ PoD = pmax * (et50/titer)^(slope) / (1+ (et50/titer)^(slope), for titers > 0} and 
\deqn{ PoD = pmax, \ for \ titers \ <= 0}{PoD = pmax for titers <= 0}.
}
\examples{
data(vaccinated)
data(PoDParams)

PoD(vaccinated$titers, pmax = PoDParams$pmax, et50 = PoDParams$et50, slope = PoDParams$slope)

}
