% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsPODBAYEfficacy.R
\name{EfficacyCI}
\alias{EfficacyCI}
\title{PoDBAY efficacy summary: mean, median, confidence intervals}
\usage{
EfficacyCI(efficacySet, ci = 0.95)
}
\arguments{
\item{efficacySet}{numeric vector: estimated PoDBAY efficacies from \code{PoDBAYEfficacy} function.}

\item{ci}{numeric: required confidence level}
}
\value{
named list: mean, median, CILow, CIHigh
}
\description{
Function summarizes PoDBAY efficacy statistics (mean, median, confidence intervals) based on the set of estimated efficacies and chosen condfidence level. (Set of efficacies is a vector obtained by number of replications specified by repeatCount. These replications are performed for calculation of a confidence interval. For more details, see the supplementary material of the article).
}
\details{
Confidence intervals are calculated using quantiles of estimated efficacies.
}
\examples{
## Data preparation
data(efficacySet)

## Example 1
EfficacyCI(efficacySet, ci = 0.95)

}
