% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsImmunogenicitySample.R
\name{BlindSampling}
\alias{BlindSampling}
\title{Immunogenicity subset: vaccinated, control, non-diseased}
\usage{
BlindSampling(diseased, 
              nondiseased,  
              method = list(name = "Full", value = NA))
}
\arguments{
\item{diseased}{\code{Population-class} object: diseased subjects, created using \code{ExtractDiseased} function}

\item{nondiseased}{\code{Population-class} object: non-diseased subjects, created using \code{ExtractNondiseased} function}

\item{method}{named list: "name" possible inputs "Full", "Ratio", "Fixed";

"value" = numeric value}
}
\value{
\itemize{
  \item ImmunogenicityVaccinated: vaccinated subjects in the immunogenicity subset, \code{Population-class} object (N, mean, stdDev, titers)

  \item ImmunogenicityControl: control subjects in the immunogenicity subset, \code{Population-class} object (N, mean, stdDev, titers)

  \item ImmunogenicityNondiseased: non-diseased subjects in the immunogenicity subset, \code{Population-class} object (N, mean, stdDev, titers)
}
}
\description{
Function creates non-diseased immunogenicity subset, and vaccinated and control immunogenicity subsets based on chosen method. The immunogenicity subsets are provided in the form of population class objects (see the \code{Population-class} function for more details).
}
\details{
For details about the method parameter see \code{ImmunogenicitySubset} function.
}
\examples{
# Data preparation
data(diseased)
data(nondiseased)

## Example 1
# Creating immunogenicity subset, method = "Full"
ImmunogenicitySubsetFull <- 
    BlindSampling(diseased, 
                  nondiseased, 
                  method = list(name = "Full", 
                                value = NA))

## Example 2
# Creating of immunogenicity subset, method = "Ratio"
ImmunogenicitySubsetRatio <- 
    BlindSampling(diseased, 
                  nondiseased, 
                  method = list(name = "Ratio", 
                                value = 4))

## Example 3
# Creating of immunogenicity subset, method = "Fixed"
ImmunogenicitySubsetFixed <- 
    BlindSampling(diseased, 
                  nondiseased, 
                  method = list(name = "Fixed", 
                                value = 100))

}
