% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_kmers.R
\name{VDJ_kmers}
\alias{VDJ_kmers}
\title{Calculates and plots kmers distributions and frequencies.}
\usage{
VDJ_kmers(
  VDJ,
  sequence.column,
  grouping.column,
  pool.per.group,
  kmer.k,
  max.kmers,
  specific.kmers,
  plot.format,
  as.proportions
)
}
\arguments{
\item{VDJ}{VDJ dataframe output from the VDJ_GEX_matrix function.}

\item{sequence.column}{Character vector. One or more sequence column names from the VDJ for kmer counting. if more than one column is provided (e.g. c("VDJ_cdr3s_aa","VJ_cdr3s_aa")) these columns will be pasted together before counting the kmers.}

\item{grouping.column}{Character. Column name of a column to group kmer counting by. This could be "sample_id" to group each kmer by the sample.}

\item{pool.per.group}{Boolean. If TRUE, will sum the kmer counts of each sequence per grouping factor (determined in grouping.column).}

\item{kmer.k}{Integer. Length k of each kmer.}

\item{max.kmers}{Integer. Maximum number of kmers to be plotted in the output barplots.}

\item{specific.kmers}{Character vector. Specific kmers to be plotted in the output barplots.}

\item{plot.format}{Character. The output plot format: 'barplot' for barplots of kmer frequency per group, 'pca' for group-level PCA reduction across the kmer vectors, 'density' for kmer count density plots.}

\item{as.proportions}{Boolean. If TRUE, will return the kmer barplot as proportions instead of absolute counts.}
}
\value{
Returns a ggplot with the kmer analysis depedning on the plot.format parameter
}
\description{
Calculates and plots kmers distributions and frequencies.
}
\examples{
\donttest{
try({
 VDJ_kmers(VDJ = Platypus::small_vgm[[1]],
 sequence.column = c("VDJ_cdr3s_aa"), grouping.column = "sample_id", kmer.k = 2, max.kmers = 5)
 })
}

}
