% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenes_api.R
\name{scenes}
\alias{scenes}
\alias{create_scene}
\alias{create_group_scene}
\alias{get_scenes}
\alias{get_scene}
\alias{set_scene_attributes}
\alias{set_scene_lightstate}
\alias{delete_scene}
\title{Hue API: \code{scenes} endpoints}
\usage{
create_scene(name, lights, recycle = TRUE, transitiontime = 4)

create_group_scene(name, group_id, recycle = TRUE, transitiontime = 4)

get_scenes()

get_scene(id)

set_scene_attributes(id, ...)

set_scene_lightstate(scene_id, light_id, ...)

delete_scene(id)
}
\arguments{
\item{name}{name to assign to the scene}

\item{lights}{vector of light IDs included in the scene}

\item{recycle}{logical indicating whether the scene can be automatically
deleted by the bridge}

\item{transitiontime}{duration (in milliseconds) of the scene transition}

\item{group_id}{ID of group that scene belongs to}

\item{id, scene_id}{ID of a specific scene}

\item{...}{named parameters describing scene attributes or light state
(e.g. \code{name = "foo"}; \code{on = TRUE})}

\item{light_id}{ID of a specific light in the scene}
}
\value{
Requests that create resources return the ID of the newly created
item, requests with side effects return \code{TRUE} upon success, and GET
requests return the response content, parsed into a list.
}
\description{
Hue API: \code{scenes} endpoints
}
\seealso{
\url{https://developers.meethue.com/develop/hue-api/4-scenes/}
}
