% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n1_n2_m2_to_cap_hist.R
\name{n1_n2_m2_to_cap_hist}
\alias{n1_n2_m2_to_cap_hist}
\title{Convert n1, n2, m2 to capture history data for use in estimating. Vectors are transformed to strata.}
\usage{
n1_n2_m2_to_cap_hist(
  n1,
  n2,
  m2,
  strata = paste0("Stratum_", 1:length(m2)),
  stratum_var = "Stratum"
)
}
\arguments{
\item{n1}{Number of animals marked and released. If a vector, there are the numbers in each stratum}

\item{n2}{Number of animals examined for marks.}

\item{m2}{Number of marked animals from n1 seen in n2.}

\item{strata}{Stratum labels. Added to the data frame if n1, n2, m2 are vectors.}

\item{stratum_var}{Name of variable to contain stratum labels.}
}
\value{
A data frame with the capture history, frequency.
\itemize{
\item \strong{cap_hist} Capture history (see details below)
\item \strong{freq} Number of times this capture history was observed
}
If the inputs are vectors, a stratum variable is also added.
}
\description{
Convert n1, n2, m2 to capture history data for use in estimating. Vectors are transformed to strata.
}
\examples{

# Rodli Tarn n1=109, n2=177, m2=57
cap_hist <- n1_n2_m2_to_cap_hist(n1=109, n2=177, m2=57)
cap_hist
fit <- Petersen::LP_fit(data=cap_hist, p_model=~..time)
fit$summary
# Now to get the estimated abundance
est <- Petersen::LP_est(fit, N_hat=~1)
est$summary

#stratified example - Northern Pike stratified by sex
cap_hist <- n1_n2_m2_to_cap_hist(n1=c(4045,2777), n2=c(613,527), m2=c(89,68),
                strata=c("F","M"),stratum_var="Sex")
cap_hist

}
\author{
Schwarz, C. J. \email{cschwarz.stat.sfu.ca@gmail.com}.
}
