% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LP_summary_stats.R
\name{LP_summary_stats}
\alias{LP_summary_stats}
\title{Compute summary statistics from the capture histories}
\usage{
LP_summary_stats(data)
}
\arguments{
\item{data}{Data frame containing the variables:
\itemize{
\item \strong{cap_hist} Capture history (see details below)
\item \strong{freq} Number of times this capture history was observed
}
plus any other covariates (e.g. discrete strata and/or continuous covariates) to be used
in the model fitting.}
}
\value{
Summary statistics of \emph{n1} (number observed at first occasion), \emph{n2} (number observed at second occasion),
and \emph{m2} number recaptured in second occasion.
}
\description{
This function takes the capture histories and computes $n_1$, $n_2$ and $m_2$.
}
\examples{

data(data_rodli)
LP_summary_stats(data_rodli)

}
