% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data_sim_tagloss_twoD}
\alias{data_sim_tagloss_twoD}
\title{Simulated data for tag loss with 2 distinguishable tags.}
\format{
\subsection{\code{data_sim_tagloss_twoD}}{

A data frame with many rows and 2 columns

\describe{
\item{\code{cap_hist}.}{Capture history (1000, 1010, 1100, 1110, 1101, 1111).}
\item{\code{freq}.}{Number of fish with this history.}
}
}
}
\usage{
data(data_sim_tagloss_twoD)
}
\description{
This is simulated data with the parameter values given in the description.
}
\details{
\preformatted{data_sim_tagloss_twoD <-LPTL_simulate(
      dt_type="twoD",         # two distinguishable tags
      N=10000,
      cov1=function(N)         {rep(1,N)},
      cov2=function(cov1)      {rep(1,  length(cov1))},
      p1  =function(cov1, cov2){rep(.1, length(cov1))},
      pST =function(cov1, cov2){rep(.25,length(cov1))},
      rho1=function(cov1, cov2){rep(.70,length(cov1))},
      rho2=function(cov1, cov2){rep(.80,length(cov1))},
      p2  =function(cov1, cov2){rep(.1, length(cov1))},
      seed=234523, trace=FALSE)}
}
\keyword{datasets}
