% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAPM.alpha.R
\name{SFM.alpha}
\alias{SFM.alpha}
\alias{CAPM.alpha}
\title{Calculate single factor model (CAPM) alpha}
\usage{
SFM.alpha(
  Ra,
  Rb,
  Rf = 0,
  ...,
  digits = 3,
  benchmarkCols = T,
  method = "LS",
  family = "mopt",
  warning = T
)
}
\arguments{
\item{Ra}{an xts, vector, matrix, data frame, timeSeries or zoo object of
asset returns}

\item{Rb}{return vector of the benchmark asset}

\item{Rf}{risk free rate, in same period as your returns}

\item{\dots}{Other parameters like max.it or bb specific to lmrobdetMM regression.}

\item{digits}{Number of digits to round the results to. Defaults to 3.}

\item{benchmarkCols}{Boolean to show the benchmarks as columns. Defaults to TRUE.}

\item{method}{string representing linear regression model, "LS" for Least Squares
and "Robust" for robust. Defaults to "LS"}

\item{family}{If method == "Robust": 
  This is a string specifying the name of the family of loss function
  to be used (current valid options are "bisquare", "opt" and "mopt").
  Incomplete entries will be matched to the current valid options. 
  Defaults to "mopt".
Else: the parameter is ignored}

\item{warning}{Boolean to show warnings or not. Defaults to TRUE.}
}
\description{
This is a wrapper for calculating a single factor model (CAPM) alpha.
}
\details{
"Alpha" purports to be a measure of a manager's skill by measuring the
portion of the managers returns that are not attributable to "Beta", or the
portion of performance attributable to a benchmark.

While the classical CAPM has been almost completely discredited by the 
literature, it is an example of a simple single factor model, 
comparing an asset to any arbitrary benchmark.
}
\examples{

# First we load the data
    data(managers)
    SFM.alpha(managers[, "HAM1"], managers[, "SP500 TR"], Rf = managers[, "US 3m TR"])
    SFM.alpha(managers[,1:3], managers[,8:10], Rf=.035/12) 
    # SFM.alpha(managers[,1], managers[,8:10], Rf=.035/12, benchmarkCols=FALSE) # other variations
if(requireNamespace("RobStatTM", quietly = TRUE)) { # CRAN requires conditional execution
   alphas <- SFM.alpha(managers[,1:6], 
		                  	managers[,8:10], 
			                  Rf=.035/12, method="Robust", 
			                  family="opt", bb=0.25, max.it=200, digits=4)
	  alphas["HAM1", ]
	  alphas[, "Alpha : SP500 TR"]
} # CRAN can have issues with RobStatTM 

}
\references{
Sharpe, W.F. Capital Asset Prices: A theory of market
equilibrium under conditions of risk. \emph{Journal of finance}, vol 19,
1964, 425-442. \cr Ruppert, David. \emph{Statistics and Finance, an
Introduction}. Springer. 2004. \cr
}
\seealso{
\code{\link{CAPM.beta}} \code{\link{CAPM.utils}}
}
\author{
Dhairya Jain, Peter Carl
}
