% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DownsideSharpeRatio.R
\name{DownsideSharpeRatio}
\alias{DownsideSharpeRatio}
\title{Downside Sharpe Ratio}
\usage{
DownsideSharpeRatio(R, rf = 0, SE = FALSE, SE.control = NULL, ...)
}
\arguments{
\item{R}{Data of returns for one or multiple assets or portfolios.}

\item{rf}{Risk-free interest rate.}

\item{SE}{TRUE/FALSE whether to ouput the standard errors of the estimates of the risk measures, default FALSE.}

\item{SE.control}{Control parameters for the computation of standard errors. Should be done using the \code{\link{RPESE.control}} function.}

\item{...}{Additional parameters.}
}
\value{
A vector or a list depending on \code{se.method}.
}
\description{
\code{DownsideSharpeRatio} computation with standard errors
}
\details{
The Downside Sharpe Ratio (DSR) is a short name for what Ziemba (2005) called the "Symmetric Downside Risk Sharpe Ratio" and is
defined as the ratio of the mean excess return to the square root of lower semivariance:
 
 \deqn{\frac{\overline{(R_{a}-R_{f})}}{\sqrt{2}SemiSD(R_a)}}.
}
\examples{
# Loading data from PerformanceAnalytics
data(edhec, package = "PerformanceAnalytics")
class(edhec)
# Changing the data colnames
names(edhec) = c("CA", "CTA", "DIS", "EM", "EMN",
                 "ED", "FIA", "GM", "LS", "MA",
                 "RV", "SS", "FOF")
# Compute Rachev ratio for managers data
DownsideSharpeRatio(edhec)

}
\references{
Ziemba, W. T. (2005). The symmetric downside-risk Sharpe ratio. The Journal of Portfolio Management, 32(1), 108-122.
}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
