% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotXVG.R
\name{plotXVG}
\alias{plotXVG}
\title{Plot time series from GROMACS XVG files}
\usage{
plotXVG(XVGfile, ...)
}
\arguments{
\item{XVGfile}{A .XVG output file of the GROMACS molecular dynamics package}

\item{...}{Arguments to be passed to methods, such as graphical parameters.}
}
\description{
Read and plot output data from a XVG format file.
}
\details{
GROMACS (GROningen MAchine for Chemical Simulations) is a molecular dynamics package designed for simulations of proteins, lipids and nucleic acids. It is free, open source software released under the GNU General Public License. 
The file format used by GROMACS is XVG. This format can be displayed in graphical form through the GRACE program on UNIX/LINUX systems and the GNUPlot program on Windows. XVG files are plain text files containing tabular data separated by tabulators and two types of comments which contain data labels. Although manual editing is possible, this is not a viable option when working with multiple files of this type. 
For ease of reading, information management and data plotting, the functions \code{read.xvg} and \code{plot.xvg} were incorporated.
}
\examples{
XVGfile <- system.file("xvg-files/epot.xvg",package="Peptides")
plotXVG(XVGfile)
}
\references{
Pronk, S., Pall, S., Schulz, R., Larsson, P., Bjelkmar, P., Apostolov, R., ... & Lindahl, E. (2013). GROMACS 4.5: a high-throughput and highly parallel open source molecular simulation toolkit. Bioinformatics, 29 (7), 845-854.
}
\author{
Latest: J. Sebastian Paez <jpaezpae@purdue.edu>

Original: Daniel Osorio <dcosorioh@unal.edu.co>
}
