% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryMCMCSAR.R
\name{summary.mcmcSAR}
\alias{summary.mcmcSAR}
\alias{print.summary.mcmcSAR}
\alias{print.mcmcSAR}
\title{Summarizing Bayesian SAR Model}
\usage{
\method{summary}{mcmcSAR}(object, alpha = 0.95, plot.type = NULL, burnin = NULL, ...)

\method{print}{summary.mcmcSAR}(x, ...)

\method{print}{mcmcSAR}(x, ...)
}
\arguments{
\item{object}{an object of class "mcmcSAR", output of the function \code{\link{mcmcSAR}}.}

\item{alpha}{(optional, default = 0.95), the significance level of parameter.}

\item{plot.type}{(optional) a character that indicate if the simulations from the posterior distribution should be printed
(if \code{plot.type = "sim"}) or if the posterior distribution densities should be plotted (\code{plot.type = "dens"}). The plots can also
done using the method \link[graphics]{plot}.}

\item{burnin}{is the number of MCMC steps which will be considered as burn-in iterations. If \code{NULL} (default value),
the 50\% first MCMC steps performed are used as burn-in iterations.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class "summary.mcmcSAR" or "mcmcSAR, output of the functions \code{\link{summary.mcmcSAR}} and
\code{\link{print.summary.mcmcSAR}}.}
}
\value{
A list consisting of:
\item{n.group}{number of groups.}
\item{N}{vector of each group size.}
\item{iteration}{number of MCMC steps performed.}
\item{burnin}{number of MCMC steps which will be considered as burn-in iterations.}
\item{posterior}{matrix (or list of matrices) containing the simulations.}
\item{hyperparms}{return value of \code{hyperparms}.}
\item{accept.rate}{acceptance rate of zeta.}
\item{prop.net}{proportion of observed network data.}
\item{method.net}{network formation model specification.}
\item{formula}{input value of \code{formula}.}
\item{alpha}{significance level of parameter.}
\item{ctrl.mcmc}{return value of \code{ctrl.mcmc}.}
\item{...}{arguments passed to methods.}
}
\description{
Summary and print methods for the class \code{mcmcSAR}.
}
\details{
The function is smart and allows all the possible arguments with the functions \link[base]{summary},
\link[graphics]{plot}, \link[graphics]{par}... such as \code{col}, \code{lty}, \code{mfrow}... \code{summary.mcmcSAR},
\code{print.summary.mcmcSAR} and \code{print.mcmcSAR} can be called by \code{summary} or \code{print}.
}
