% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadBackgroundNoise.R
\name{loadBackgroundNoise}
\alias{loadBackgroundNoise}
\alias{plotBackgroundNoise}
\alias{combineBackgroundNoise}
\title{Load and Format Background Noise Data}
\usage{
loadBackgroundNoise(x)

plotBackgroundNoise(x)

combineBackgroundNoise(x, forPlot = FALSE)
}
\arguments{
\item{x}{character pointing to a Pamguard binary file, or a \code{PamBinary}
object created by \link{loadPamguardBinaryFile}. For plotting or combining, 
either of these or the output from \link{loadBackgroundNoise}}

\item{forPlot}{logical flag when combining noise data. If used for plotting
purposes this will insert NA columns into background data so that images show
up with time gaps as expected. Leave as \code{FALSE} unless you are sure you
want this.}
}
\value{
A list with \code{times} storing the POSIXct time of each background 
  measurement, and \code{background} a matrix of background values. For binary
  data based on spectrogram measurements, there will also be \code{freq} the 
  frequency in Hertz for each column of background measurement
}
\description{
Reads and formats background noise data from Pamguard binary files
  or if not present in the original file will try to read the accompanying 
  .pgnf noise file if it exists
}
\examples{

# load the example click binary data, leaving date as numeric
gplFile <- system.file('extdata', 'GPL.pgdf', package='PamBinaries')
gplNoise <- loadBackgroundNoise(gplFile)
print(gplNoise)
plotBackgroundNoise(gplNoise)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
