% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PVBcorrect_functions.R
\name{acc_ipw}
\alias{acc_ipw}
\title{PVB correction by Inverse Probability Weighting Estimator method}
\usage{
acc_ipw(
  data,
  test,
  disease,
  covariate = NULL,
  saturated_model = FALSE,
  ci = FALSE,
  ci_level = 0.95,
  ci_type = "basic",
  R = 999,
  seednum = NULL,
  show_fit = FALSE,
  show_boot = FALSE,
  r_print_freq = 100,
  description = TRUE
)
}
\arguments{
\item{data}{A data frame, with at least "Test" and "Disease" variables.}

\item{test}{The "Test" variable name, i.e. the test result. The variable must be in binary; positive = 1, negative = 0 format.}

\item{disease}{The "Disease" variable name, i.e. the true disease status. The variable must be in binary; positive = 1, negative = 0 format.}

\item{covariate}{The name(s) of covariate(s), i.e. other variables associated with either test or disease status.
Specify as name vector, e.g. c("X1", "X2") for two or more variables. The variables must be in formats acceptable to GLM.}

\item{saturated_model}{Set as \code{TRUE} to obtain the original Begg and Greenes' (1983) when all possible interactions are included.}

\item{ci}{View confidence interval (CI). The default is \code{FALSE}.}

\item{ci_level}{Set the CI width. The default is 0.95 i.e. 95\% CI.}

\item{ci_type}{Set confidence interval (CI) type. Acceptable types are "norm", "basic", "perc", and "bca",
for bootstrapped CI. See \code{\link[boot]{boot.ci}} for details.}

\item{R}{The number of bootstrap samples. Default \code{R = 999}.}

\item{seednum}{Set the seed number for the bootstrapped CI. The default is not set, so it depends on the user
to set it outside or inside the function.}

\item{show_fit}{Set to \code{TRUE} to view model fit summary for the logistic regression model.}

\item{show_boot}{Set to \code{TRUE} to show bootstrap iterations.}

\item{r_print_freq}{Print the current bootstrap sample number at each specified interval.
Default \code{r_print_freq = 100}.}

\item{description}{Print the name of this analysis. The default is \code{TRUE}. This can be turned off for repeated analysis, for example in bootstrapped results.}
}
\value{
A list object containing:
\describe{
  \item{acc_results}{The accuracy results.}
}
}
\description{
Perform PVB correction by Inverse Probability Weighting Estimator method (Alonzo & Pepe, 2005).
}
\examples{
# point estimates
acc_ipw(data = cad_pvb, test = "T", disease = "D")
acc_ipw(data = cad_pvb, test = "T", disease = "D", covariate = "X3")

# with bootstrapped confidence interval
acc_ipw(data = cad_pvb, test = "T", disease = "D", ci = TRUE, R = 99, seednum = 12345)
}
\references{
\enumerate{
  \item{Alonzo, T. A., & Pepe, M. S. (2005). Assessing accuracy of a continuous screening test in the presence of verification bias. Journal of the Royal Statistical Society: Series C (Applied Statistics), 54(1), 173–190.}
  \item{He, H., & McDermott, M. P. (2012). A robust method using propensity score stratification for correcting verification bias for binary tests. Biostatistics, 13(1), 32–47.}
}
}
