% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lewicki3MSI.R
\name{Lewicki3MSI}
\alias{Lewicki3MSI}
\title{Lewicki-3-Parameter Moisture Sorption Isotherm}
\usage{
Lewicki3MSI(WaterAct, AdsorpM, DesorpM)
}
\arguments{
\item{WaterAct}{the numerical value of Water Activity, which ranges from 0 to 1.}

\item{AdsorpM}{the numerical value of the Moisture content of the Adsorption curve, which ranges from 0 to 1.}

\item{DesorpM}{the numerical value of the Moisture content of the Desorption curve, which ranges from 0 to 1.}
}
\value{
the nonlinear regression, parameters, and graphical visualization for Lewicki-3-Parameter model.
}
\description{
The three-parameter Lewicki model is most suitable for describing the sorption characteristics of raw potato, potato starch, starch-sugar and starch-salt gels within specific temperature and water activity ranges.
}
\examples{
WaterAct <- c(0.1145,0.2274,0.3265,0.4291,0.6342,0.7385,0.8274,0.9573)
AdsorpM <- c(0.0234, 0.0366, 0.0496, 0.0648, 0.0887, 0.1096, 0.1343, 0.1938)
DesorpM <- c(0.0459, 0.0637, 0.0794, 0.0884, 0.1158, 0.1298,0.1500, 0.1938)
Lewicki3MSI(WaterAct, AdsorpM, DesorpM)
}
\references{
McMinn, W. A., et al. (2004) <doi:10.1002/jsfa.1866> Assessment of two- and three-parameter Lewicki models for description of sorption phenomena of starch materials. Journal of the Science of Food and Agriculture, 84(13), 1695-1700.
}
\author{
Benz L. Rivera

John Carlo F. Panganiban

Kim M. Villacorte

Chester C. Deocaris
}
