% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mod2.test.R
\name{Mod2.test}
\alias{Mod2.test}
\title{Modular test for independence in two-way contingency table}
\usage{
Mod2.test(nij, B = 10000)
}
\arguments{
\item{nij}{a numeric matrix with non-negative values of the two-way contingency table cells}

\item{B}{an integer specifying the number of replicates used in the Monte Carlo test (optional)}
}
\value{
The function returns values of the test statistic and p-value of the modular test.
}
\description{
Calculates the test statistic and p-value of the modular test for independence in two-way contingency table
}
\details{
The test statistic and p-value of the modular test for independence in r x c contingency table,
}
\examples{
pij=matrix(1/4, nrow = 2, ncol = 2)
\donttest{Mod2.test(GenTab2(pij, 50), B = 1e3)}
\donttest{Mod2.test(table1, B = 1e2)}

}
\references{
{Sulewski, P. (2016). \emph{Moc testów niezależności w tablicy dwudzielczej większej niż 2×2,} Przegląd statystyczny 63(2), 190-210}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
