% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_submissions}
\alias{search_submissions}
\title{Search Pushshift.io for Reddit submissions}
\usage{
search_submissions(
  q = "",
  subreddit = NULL,
  size = 25,
  after = NULL,
  before = NULL,
  parse_date = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{q}{character, Query term}

\item{subreddit}{Restrict results to subreddit (use "!" to negate, comma delimited for multiples)}

\item{size}{integer, Number of results to return}

\item{after}{integer, Restrict results to those made after this epoch time}

\item{before}{integer, Restrict results to those made before this epoch time}

\item{parse_date}{logical, should epoch time be converted to date? defaults to TRUE}

\item{verbose}{logical, Whether to display messages}

\item{...}{Further arguments passed as query parameters. See [ps_params] for all possible parameters.}
}
\value{
tibble of submissions
}
\description{
Search Pushshift.io for Reddit submissions
}
\details{
Use [to_epoch] to convert a date to epoch time
}
\examples{
\dontrun{
# get the last 100 submissions with the word 'dogs' in the subreddit 'r/animals'
search_submissions(q = "dogs", subreddit = "animals", size = 100)
}
}
