% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/struc_saveSimData.R
\name{struc_saveSimData}
\alias{struc_saveSimData}
\title{Saving simulation data}
\usage{
struc_saveSimData(rep_counter, simcycle, start_names, end_names, simstruc)
}
\arguments{
\item{rep_counter}{number of the current repetition. \code{integer}.}

\item{simcycle}{number of the current simulation cycle. \code{integer}.}

\item{start_names}{names of the columns with the first population stage in the simulation. \code{character}.}

\item{end_names}{names of the columns with the last population stage in the simulation. These are taken as the first stage in the next simulation cycle. \code{character}.}

\item{simstruc}{two numbers, the first defines the number of repetitions for the simulation, the second defines the number of simulation cycles in each repetition of the simulation. \code{numeric vector} with length 2.}
}
\value{
A \code{prosper} object. SimData as a \code{data.table} with the repetition in the first and the simulation cycle in the second column.
}
\description{
\code{struc_saveSimData} collects the data of one simulation cycle and returns an object to start a new simulation cycle.
}
\details{
In the first simulation cycle the object \code{sim_result} of the class \code{prosper} is created and the first cycle results are saved. This object is the same for all cycles in all repetitions and gets all the results. The function can only be called once per simulation run.
}
\examples{
struc_preparation2(Rmx=10, af=c(2,1), epis=0, dom=c(1,0.3))
dfgenotype$"SB_autumn" <- c(4,23,0,123,53,98,45,3245,234)
dfgenotype$"SB_autumn_end" <- c(0,2,0,123,434,5234,5678,123,2)
#creation of an example object with data of the first year
struc_saveSimData(rep_counter=1, simcycle=1, simstruc=c(5, 10), 
                                 start_names="SB_autumn", end_names="SB_autumn_end")
#creating some fictional population stages
dfgenotype$"SB_autumn" <- c(1,1,1,1,0,0,0,0,4)
dfgenotype$"SB_autumn_end" <- c(67,67,67,67,67,67,67,67,67)
#appending rows with the new results to the first results. necessary columns are inserted.
struc_saveSimData( rep_counter=1, simcycle=2,
                     start_names="SB_autumn", end_names="SB_autumn_end",
                      simstruc=c(repetitions, duration)) 
sim_result                               
rm(sim_result, dfgenotype, mf, xprobab)                               
}
\seealso{
\code{\link{struc_endSim}}
}
