% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_MADE.R
\name{plot_MADE}
\alias{plot_MADE}
\title{Generic plot function for 'MADE' objects}
\usage{
plot_MADE(
  data,
  v_lines,
  legend_position,
  color,
  numbers,
  number_size,
  numbers_ynudge,
  caption,
  x_lab,
  x_breaks,
  x_limits,
  y_breaks,
  y_limits,
  y_expand = NULL,
  warning,
  traffic_light_assumptions,
  ...
)
}
\arguments{
\item{data}{Data/object for which the plot should be made.}

\item{v_lines}{Integer or vector to specify vertical line(s) in within each
plot. Default is \code{NULL}.}

\item{legend_position}{Character string to specify position of legend. Default is \code{"bottom"}.}

\item{color}{Logical indicating whether to use color in the plot(s). Default is \code{TRUE}.}

\item{numbers}{Logical indicating whether to number the plots. Default is \code{TRUE}.}

\item{number_size}{Integer value specifying the size of the (optional) plot
numbers. Default is \code{2.5}.}

\item{numbers_ynudge}{Integer value for vertical nudge of the (optional) plot
numbers.}

\item{caption}{Logical indicating whether to include a caption with detailed
information regarding the analysis. Default is \code{TRUE}.}

\item{x_lab}{Title for the x-axis. If \code{NULL} (the default), the x_lab is
specified automatically.}

\item{x_breaks}{Optional vector to specify breaks on the x-axis. Default is \code{NULL}.}

\item{x_limits}{Optional vector of length 2 to specify the limits of the
x-axis. Default is \code{NULL}, which allows limits to be determined automatically from the data.}

\item{y_breaks}{Optional vector to specify breaks on the y-axis.}

\item{y_limits}{Optional vector of length 2 to specify the limits of the
y-axis.}

\item{y_expand}{Optional vector to expand the limits of the y-axis. Default is \code{NULL}.}

\item{warning}{Logical indicating whether warnings should be returned when
multiple models appear in the data. Default is \code{TRUE}.}

\item{traffic_light_assumptions}{Optional logical to specify coloring of
strips of the facet grids to emphasize assumptions about the likelihood the
given analytical scenario. See Vembye, Pustejovsky, & Pigott (In
preparation) for further details.}

\item{...}{Additional arguments available for some classes of objects.}
}
\value{
A \code{ggplot} object
}
\description{
Create a faceted plot displaying the results of a set of power
analyses. This is a generic function to make facet_grid plots, with
specific methods defined for \code{\link{power_MADE}},
\code{\link{mdes_MADE}}, and \code{\link{min_studies_MADE}} objects.
}
\examples{
power_dat <-
  power_MADE(
    J = c(50, 56),
    mu = 0.15,
    tau = 0.1,
    omega = 0.05,
    rho = 0,
    sigma2_dist = 4 / 200,
    n_ES_dist = 6
  )

power_example <-
  plot_MADE(
   data = power_dat,
   power_min = 0.8,
   expected_studies = c(52, 54),
   warning = FALSE,
   caption = TRUE,
   color = TRUE,
   model_comparison = FALSE,
   numbers = FALSE
   )

power_example


}
\references{
Vembye, M. H., Pustejovsky, J. E., & Pigott, T. D. (In
preparation). Conducting power analysis for meta-analysis of dependent
effect sizes: Common guidelines and an introduction to the POMADE R
package.
}
\seealso{
\code{\link{plot_MADE.power}}, \code{\link{plot_MADE.mdes}},
\code{\link{plot_MADE.min_studies}}
}
