% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnds_deflator.R
\name{pnds_deflator}
\alias{pnds_deflator}
\title{Add deflator variables to PNDS microdata}
\usage{
pnds_deflator(data_pnds, deflator.file)
}
\arguments{
\item{data_pnds}{A tibble of PNDS microdata read with \code{read_pnds} function.}

\item{deflator.file}{The deflator file for selected survey available on official website: (select the deflator zip file) - \samp{https://ftp.ibge.gov.br/PNDS/Documentacao_Geral/}.}
}
\value{
A tibble with the data provided from PNDS survey and the deflator variables added for use.
}
\description{
This function adds deflator variables to PNDS microdata. For deflation of income variables, the documentation provided through the following address must be used: \samp{https://ftp.ibge.gov.br/PNDS/Documentacao_Geral/PNDSIBGE_Deflator.pdf}.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/estatisticas/sociais/saude/9160-pesquisa-nacional-de-demografia-e-saude.html?=&t=o-que-e}> and consult the other functions of this package, described below.
}
\examples{
# Using data read from disk
input_path <- pnds_example(path="input_example.txt")
data_path <- pnds_example(path="exampledata.txt")
dictionary.path <- pnds_example(path="dictionaryexample.xls")
deflator.path <- pnds_example(path="deflatorexample.xls")
pnds.df <- read_pnds(microdata=data_path, input_txt=input_path, vars=c("J007","J009"))
pnds.df <- pnds.df[(pnds.df$M001 == "1" & !is.na(pnds.df$M001)),]
pnds.df <- pnds.df[,!(names(pnds.df) \%in\% c("V0029", "V00291", "V00292", "V00293"))]
pnds.df <- pnds_labeller(data_pnds=pnds.df, dictionary.file=dictionary.path)
pnds.df <- pnds_deflator(data_pnds=pnds.df, deflator.file=deflator.path)
\donttest{
# Downloading data
pnds.df2 <- get_pnds(year=2023, section="Female", vars=c("J007","J009"),
                       labels=TRUE, deflator=FALSE, design=FALSE,
                       reload=TRUE, curlopts=list(), savedir=tempdir())
deflator.path2 <- pnds_example(path="deflatorexample.xls")
pnds.df2 <- pnds_deflator(data_pnds=pnds.df2, deflator.file=deflator.path2)}
}
\seealso{
\link[PNDSIBGE]{get_pnds} for downloading, labeling, deflating and creating survey design object for PNDS microdata.\cr \link[PNDSIBGE]{read_pnds} for reading PNDS microdata.\cr \link[PNDSIBGE]{pnds_labeller} for labeling categorical variables from PNDS microdata.\cr \link[PNDSIBGE]{pnds_design} for creating PNDS survey design object.\cr \link[PNDSIBGE]{pnds_example} for getting the path of the PNDS toy example files.
}
