% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subgraph_plot.R
\name{subgraph_difference_plot}
\alias{subgraph_difference_plot}
\title{Visualization of a difference subgroup using a circular graph}
\usage{
subgraph_difference_plot(
  plexi.graph,
  node.importance,
  n.var.nodes = 5,
  n.neigh = 10,
  diff.threshold = 0,
  edge.width = c(0.5, 4)
)
}
\arguments{
\item{plexi.graph}{plexi.graph data}

\item{node.importance}{named numeric vector of the node importance to sort the nodes clockwise.}

\item{n.var.nodes}{number of variable nodes to show}

\item{n.neigh}{number of neighboring  nodes to show}

\item{diff.threshold}{edge threshold}

\item{edge.width}{numeric value to adjust the thickness of the edges in plot.
Two modes are defined: [i] two numbers indicating the min and max (default: c(0.5,4));
or [ii] a single number that weights the min/max of original edge weights.}
}
\value{
nothing to return
}
\description{
Visualization of a difference subgroup using a circular graph
}
\examples{
myNet = network_gen(n.nodes = 100, n.var.nodes = 5, n.var.nei = 90, noise.sd = .01)
graph_data = myNet[["data_graph"]]
node_importance_dummy = 1:100
names(node_importance_dummy) = 1:100
subgraph_difference_plot(graph_data, node.importance = node_importance_dummy)

}
