% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_walk.R
\name{rep_random_walk}
\alias{rep_random_walk}
\title{Repetitive Fixed-length (weighted) random walk algorithm}
\usage{
rep_random_walk(
  graph,
  Nrep = 100,
  Nstep = 5,
  weighted_walk = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{graph}{an igraph object}

\item{Nrep}{number of repeats (default:100)}

\item{Nstep}{maximum number steps (default:5)}

\item{weighted_walk}{choose the \emph{weighted walk} algorithm if \emph{TRUE} and \emph{simple random} walk if \emph{FALSE}. (default: \emph{TRUE})}

\item{verbose}{if \emph{TRUE} a progress bar is shown.}
}
\value{
Steps (S): The total number of times a node is visited starting from the corresponding node in the row.
Probabilities (P): The node visit probabilities starting from the corresponding node in the row.
}
\description{
Repetitive Fixed-length (weighted) random walk algorithm
}
\examples{
data = example_data()
RW = rep_random_walk(graph = data[["igraph_example"]])
Steps = RW[["Steps"]]
Probabilities = RW[["Probabilities"]]

}
