% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiLayerNet_functions.R
\name{plexi_node_distance}
\alias{plexi_node_distance}
\title{Detecting the nodes whose local neighbors change between the two conditions for ISNs.}
\usage{
plexi_node_distance(embedding.space.list)
}
\arguments{
\item{embedding.space.list}{a list obtained by the \code{plexi_embedding_2layer()} function.}
}
\value{
the distances for each repeat
}
\description{
Detecting the nodes whose local neighbors change between the two conditions for ISNs.
}
\details{
Calculating the distance of node pairs in the embedding space and check their significance.
To find the significantly varying nodes in the 2-layer-network, the distance between
the corresponding nodes are calculated along with the null distribution.
The null distribution is obtained based on the pairwise distances on null graphs.
if in \code{plexi_embedding_2layer} function \code{null.perm=FALSE}, the multiplex network
does not have the two randomly permuted graphs, thus the distances between all the nodes will
be used for the null distribution.
}
\examples{
myNet = network_gen(n.nodes = 50, n.var.nodes = 5, n.var.nei = 40, noise.sd = .01)
graph_data = myNet[["data_graph"]]
embeddingSpaceList = plexi_embedding(graph.data=graph_data, outcome=c(1,2),
indv.index=c(1,1), train.rep=2, random.walk=FALSE)
Dist = plexi_node_distance(embeddingSpaceList)

}
