% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{abundance}
\alias{abundance}
\title{Vector of frequencies of frequencies}
\usage{
abundance(x)
}
\arguments{
\item{x}{Data vector \code{x}.}
}
\value{
This function returns a named vector with the frequencies of the frequencies in the data vector x.
The function \code{base::table(x)} returns a contingency table with the frequencies in the input data vector \code{x} as
values. The \code{names(table(x))} are the unique values in data vector \code{x}. In \code{abundance(x)},
the unique values in \code{table(x)} become the names of the values, while the values
themselves are the frequencies of the frequencies of data vector \code{x}.
}
\description{
A function to calculate the abundance vector, or frequencies of frequencies of discrete or partly discrete
data vector \code{x}. The abundance vector is used as input in the functions \code{dPD()}, \code{MLEp()}, and \code{LMTp()}.
}
\details{
This function is equivalent to \code{table(table(x))}.
}
\examples{
set.seed(111)
x<-rpois(10,10)
## The frequency table of x:
print(table(x))
## The frequency table of the frequency table of x:
abundance(x)
}
\keyword{abundance}
