% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimPDXdata.R
\name{SimPDXdata}
\alias{SimPDXdata}
\title{A function to calculate the power under pre-specified effect size,
variance, and correlation using Monte Carlo sampling scheme by fitting ANOVA fixed effects model,
ANOVA random effects model, Cox model, and frailty model.}
\usage{
SimPDXdata(
  seed = 1000,
  n,
  m,
  beta,
  tau2,
  lambda = 0.03,
  nu = 2,
  sigma2 = 1,
  distr = c("Weibull", "normal"),
  two.sided = TRUE,
  Ct = 5,
  censor = TRUE
)
}
\arguments{
\item{seed}{an integer random seed number.}

\item{n}{an integer number to specify the number of PDX lines.}

\item{m}{an integer number to specify the number of individuals per PDX line per treatment.}

\item{beta}{Treatment effect for the treated group.}

\item{tau2}{Error variance of random effect.}

\item{lambda}{Scale parameter of Weibull distribution for the baseline hazard.}

\item{nu}{Shape parameter of Weibull distribution for the baseline hazard.}

\item{sigma2}{Error variance of log survival time for both treatment groups.}

\item{distr}{distributional assumption of survival time.}

\item{two.sided}{a logical value to indicate if a two-sided test is performed. Default is TRUE.}

\item{Ct}{a fixed time point when a study is designed to end for generating type 1 censoring data.}

\item{censor}{logical value of whether a censoring distribution is considered in a data generation setting. Default is TRUE.}
}
\value{
Object of \code{SimPDXdata} with elements
\item{Data}{a simulated data.}
}
\description{
A function to calculate the power under pre-specified effect size, variance, and
correlation using Monte Carlo sampling scheme
}
\examples{
require(PDXpower)
data <- SimPDXdata(n = 5, m = 3, beta = 0.8, sigma2 = 1, tau2 = 0.1,
                   distr = "normal", censor = FALSE)
}
